/**
 * 
 */
package com.ejie.ab18a.incoherencias;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.ejie.ab18a.consulta.Ab18aRealizarProcesoBD;
import com.ejie.ab18a.log.Ab18aLog;
import com.ejie.ab18a.modelo.Ab18aIncoherencia;
import com.ejie.ab18a.utilidades.Ab18aConexionOracle;
import com.ejie.ab18a.utilidades.Ab18aConstantes;
import com.ejie.ab18a.utilidades.Ab18aException;

/**
 * @author XXXX
 *
 */
public class Ab18aIncoherencias {
	
	private Ab18aIncoherencias() {
		
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) throws Ab18aException {
		Connection connectionOracle = null;
		Ab18aLog.configure("Ab18aIncoherencias", 1);
		
		String nombre_metodo = "obtenerIncoherencias";
		Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Comienza ", 1);

		try {
			if (connectionOracle == null) {
				connectionOracle = Ab18aConexionOracle.conectar(args);
			}
			
			Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Conexión abierta", 1);
			
			// TODO Obtenemos los distintos expedientes
			List<String> listaExpedientes = Ab18aRealizarProcesoBD.getInstance().obtenerExpedientes(connectionOracle);
			
			Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Expedientes recuperados", 1);
			
			if (listaExpedientes != null && !listaExpedientes.isEmpty()) {
				
				boolean anuncioAbierto = false;
				boolean anuncioFormalizado = false;
				// TODO Por cada expediente obtenido comprobamos si tienen un anuncio "abierto" en estado publicado y un anuncio "formalizado" en estado publicado
				for (String expediente : listaExpedientes) {
					Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Procesando el expediente " + expediente, 1);
					
					anuncioAbierto = Ab18aRealizarProcesoBD.getInstance().obtenerAnuncioExpediente(connectionOracle, expediente, Ab18aConstantes.ABIERTO);
					anuncioFormalizado = Ab18aRealizarProcesoBD.getInstance().obtenerAnuncioExpediente(connectionOracle, expediente, Ab18aConstantes.FINALIZADO);
					
					Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Anuncio abierto encontrado: " + anuncioAbierto, 1);
					Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Anuncio formalizado encontrado: " + anuncioFormalizado, 1);
					
					// Si el expediente contiene ambos anuncios
					if (anuncioAbierto && anuncioFormalizado) {
						// Comprobamos si el expediente tiene una incoherencia
						Integer idIncoherencia = Ab18aRealizarProcesoBD.getInstance().findIncoherenciaByExpediente(connectionOracle, expediente);
						Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Incoherencia encontrada " + idIncoherencia, 1);
						
						if (idIncoherencia != null && idIncoherencia > 0) {
							// Si ya tenia una incoherencia anterior la damos de baja, porque ya estaría resuelta
							Ab18aIncoherencia incoherencia = new Ab18aIncoherencia();
							incoherencia.setIdIncoherencia(idIncoherencia);
							Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Antes de updatear la incoherencia " + idIncoherencia, 1);
							Ab18aRealizarProcesoBD.getInstance().updateIncoherencia(connectionOracle, incoherencia);
							Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Despues de updatear la incoherencia " + idIncoherencia, 1);
						}
					} else {
						// Comprobamos si el expediente ya tiene una incoherencia
						// Comprobamos si el expediente tiene una incoherencia
						Integer idIncoherencia = Ab18aRealizarProcesoBD.getInstance().findIncoherenciaByExpedienteBaja(connectionOracle, expediente);
						Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Incoherencia encontrada " + idIncoherencia, 1);
						
						if (idIncoherencia == null || idIncoherencia <= 0) {
							// Si el expediente no contiene un anuncio abierto pero si el formalizado publicado
							if (!anuncioAbierto && anuncioFormalizado) {
								Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Antes de insertar incoherencia abierta", 1);
								Ab18aRealizarProcesoBD.getInstance().insertarIncoherencia(connectionOracle, expediente, Ab18aConstantes.ID_INCOHERENCIA_ABIERTA);
								Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Incoherencia abierta insertada", 1);
							// Si el expediente contiene un anuncio abierto pero no el formalizado
							} else if (!anuncioFormalizado && anuncioAbierto) {
								// Comprobamos si ha transcurrido el plazo de incoherencias parametrizado en la tabla AB18A00T00
								Integer plazoIncoherencia = Ab18aRealizarProcesoBD.getInstance().obtenerPlazoIncoherencia(connectionOracle);
								
								if (plazoIncoherencia == null || plazoIncoherencia.compareTo(0) == 0) {
									plazoIncoherencia = 60;
								}
								
								Date fechaPlazo = Ab18aRealizarProcesoBD.getInstance().obtenerFechaAltaExpediente(connectionOracle, expediente);
								Calendar cal = Calendar.getInstance();
								Date fechaActual = cal.getTime();
								
								if (fechaPlazo != null) {
									cal.setTime(fechaPlazo);
									cal.add(Calendar.DATE, plazoIncoherencia);
									fechaPlazo = cal.getTime();
									
									// Si la fecha de plazo se encuentra antes que la fecha actual, significa que ha expirado el plazo
									if (fechaPlazo.before(fechaActual)) {
										Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Antes de insertar incoherencia formalizada", 1);
										Ab18aRealizarProcesoBD.getInstance().insertarIncoherencia(connectionOracle, expediente, Ab18aConstantes.ID_INCOHERENCIA_FORMALIZADO);
										Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Incoherencia formalizada insertada", 1);
									} else {
										Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "No se ha alcanzado la fecha de plazo para el expediente: " + expediente, 1);
										Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "Fecha de plazo: " + fechaPlazo + " , Fecha actual: " + fechaActual, 1);
									}
								} else {
									Ab18aLog.debug(Ab18aIncoherencias.class.getName(), nombre_metodo, "El expediente " + expediente + " no tiene una fecha de publicación", 1);
								}
							}
						}
					}
				}
			}
			
			// TODO En caso de tener ambos anuncios, comprobar si existe una incoherencia y darla de baja

			
		} catch (Exception e) {
			Ab18aLog.error(Ab18aIncoherencias.class.getName(), nombre_metodo, "Expedientes recuperados", 1);
		}
	}
}
